/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;

public class FixupScriptExecutionJob
extends Job
implements Callable<FixupResultSet> {
    private static Resource resource = Application.getInstance().getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
    List<VerificationTask> fixableTasks;
    private boolean automaticFixupExecution;
    private static final Logger logger = Logger.getLogger(FixupScriptExecutionJob.class.getName());

    public FixupScriptExecutionJob(List<VerificationTask> fixableTasks, boolean autoFixupExectuion) {
        super(resource.getString("FixupScriptExecutionJob.id", "Fixup", new Object[0]), resource.getString("FixupScriptExecutionJob.description", "Fixup execution task", new Object[0]), 0.25f);
        this.fixableTasks = fixableTasks;
        this.automaticFixupExecution = autoFixupExectuion;
    }

    public void setFixableTasks(List<VerificationTask> tasks) {
        this.fixableTasks = tasks;
    }

    public List<VerificationTask> getFixableTasks() {
        return this.fixableTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FixupResultSet call() {
        this.setStatus(Status.INPROGRESS);
        Status status = Status.FAILED;
        if (this.fixableTasks != null && this.fixableTasks.size() > 0) {
            try {
                ClusterVerification cvu = ClusterVerification.getInstance();
                if (this.automaticFixupExecution) {
                    cvu.executeFixupsAutomated();
                } else {
                    cvu.executeFixupsManual();
                }
                this.setStatus(Status.SUCCEEDED);
            }
            catch (RootAutomationException e) {
                logger.log(Level.WARNING, "Root automation exception occurred while executing fixups", e);
                this.setStatusMessage(new DefaultErrorMessage((Throwable)e, (ErrorCode)PrereqCheckerErrorCode.FIXUP_ROOT_AUTOMATION_EXCEPTION, new Object[0]));
                status = Status.FAILED;
                FixupResultSet fixupResultSet = null;
                return fixupResultSet;
            }
            catch (FixupException e) {
                logger.log(Level.WARNING, "Fixup exception occurred while executing fixups", e);
                this.setStatusMessage(new DefaultErrorMessage((Throwable)e, (ErrorCode)PrereqCheckerErrorCode.FIXUP_EXCEPTION, new Object[0]));
                status = Status.FAILED;
                FixupResultSet fixupResultSet = null;
                return fixupResultSet;
            }
            catch (VerificationException e) {
                logger.log(Level.WARNING, "unable to create instance of ClusterVerification while executing fixups", e);
                status = Status.FAILED;
                FixupResultSet fixupResultSet = null;
                return fixupResultSet;
            }
            finally {
                this.setStatus(status);
                this.logResults();
            }
        } else {
            this.setStatus(Status.SUCCEEDED);
        }
        return null;
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    public void logResults() {
        logger.info("***********FIXUP EXECUTION RESULT*************");
        for (VerificationTask task : this.fixableTasks) {
            List errors;
            logger.info("-------------TASK:" + task.getElementName() + "-------------");
            FixupResultSet resultSet = task.getFixupResultSet();
            logger.info(task.getElementName() + ": " + task.getDescription());
            logger.info("Fixup OverallStatus:" + resultSet.getFixupOverallStatus());
            logger.info("Reboot required for Fix:" + (task.isRebootRequiredForFixup() ? "YES" : "NO"));
            try {
                List nodeResults = resultSet.getNodeResults();
                if (nodeResults != null) {
                    for (FixupResult result : nodeResults) {
                        logger.info("-----------------------------------------------");
                        logger.info("Verification Result for Node:" + result.getNode());
                        logger.info("Node Status:" + result.getStatus());
                        List errors2 = result.getErrors();
                        if (errors2 != null) {
                            for (VerificationError error : errors2) {
                                logger.info("Error Message:" + error.getErrorMessage());
                                logger.info("Cause:" + error.getCause());
                                logger.info("Action:" + error.getAction());
                            }
                        }
                        logger.info("-----------------------------------------------");
                    }
                }
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
            if (resultSet.getFixupOverallStatus() == FixupOverallStatus.SUCCESSFUL || (errors = resultSet.getErrors()) == null) continue;
            for (VerificationError error : errors) {
                logger.info("Error Message:" + error.getErrorMessage());
                logger.info("Cause:" + error.getCause());
                logger.info("Action:" + error.getAction());
            }
        }
        logger.info("*******END OF FIXUP EXECUTION RESULT**********");
    }
}

